function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = FiscalRE16022017_correct_tax.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(15, 1);
residual(1) = y(9)-(params(1)-(params(2)-1)/params(2)*params(3))*y(5)-y(4);
lhs = y(9);
rhs = y(3)-y(5);
residual(2) = lhs - rhs;
lhs = y(16);
rhs = y(15)-y(3);
residual(3) = lhs - rhs;
lhs = y(17);
rhs = y(2)-y(3);
residual(4) = lhs - rhs;
lhs = y(8);
rhs = y(3)+x(it_, 1)-y(1)-y(12);
residual(5) = lhs - rhs;
lhs = y(3);
rhs = y(4)*params(4)+params(5)*y(7)+y(15)*params(6);
residual(6) = lhs - rhs;
lhs = y(3);
rhs = y(1)*params(7)+y(5)*(1-params(7))-x(it_, 1)*params(7)+y(12)*params(7);
residual(7) = lhs - rhs;
residual(8) = y(12)*(-params(8))*params(9)/params(10)-y(6)+y(7)*params(11)-x(it_, 1)*T(1)+y(1)*T(1);
residual(9) = y(12)+(-y(8))/(params(9)-1);
lhs = y(10);
rhs = y(3)-y(5);
residual(10) = lhs - rhs;
lhs = y(4)*(-params(2))-y(5)*params(3)*(1-params(2));
rhs = (-params(2))*y(18)-params(3)*(1-params(2))*y(19)+T(2)*y(20);
residual(11) = lhs - rhs;
lhs = y(11);
rhs = y(8)*(1-params(16))*params(8)*params(9)/params(13);
residual(12) = lhs - rhs;
residual(13) = params(14)*y(13)-params(15)*y(14)-y(6)*params(17);
residual(14) = y(15)*params(6)+T(3)*(y(2)+y(11))-y(1)*T(4)-y(8)*params(8)*params(9)*params(17)*params(16)/params(10)-(1-params(7))*params(18)*(y(9)+y(5))+x(it_, 1)*(T(4)-T(3))-params(15)*y(14)-y(4)*params(4)*params(19);
residual(15) = y(3)*(params(6)+params(20)-T(5))+T(5)*(y(2)-x(it_, 1))+x(it_, 2)-y(15)*params(6);

end
